------------------------------------------------------------------------------------------------------------------------
-- Различные игровые константы
------------------------------------------------------------------------------------------------------------------------

-- Типы урона
DamageType = {
    Piercing   = 0, -- Колющий
    Slashing   = 1, -- Рубящий
    Crushing   = 2, -- Дробящий
    Termical   = 3, -- Огонь
    Chemical   = 4, -- Кислота
    Electrical = 5, -- Молния
    General    = 6  -- Общий (или скриптовый, так как наносится скриптами вроде InflictDamage)
}

-- Типы передвижения
LocomotionType = {
    Unknown  = 0,
    Walk     = 1, -- Ходьба
    Levitate = 2, -- Левитация (досягаем для оружия ближнего боя)
    Stay     = 3, -- Стоит неподвижно
    -- Fly      = 4  -- Полет (недосягаем для оружия ближнего боя)
}

-- Части тела
HitLocationType = {
    Head       = 0, -- Голова
    Body       = 1, -- Тело
    Left_hand  = 2, -- Левая рука
    Right_hand = 3, -- Правая рука
    Left_leg   = 4, -- Левая нога
    Right_leg  = 5, -- Правая нога
    All        = 6  -- Все части тела
}

BodyPartType = {
    Head  = 0, -- Голова
    Body  = 1, -- Тело
    Hand  = 2, -- Рука
    Leg   = 3  -- Нога
}

-- Список заклинаний
SpellType = {
    Firearrow        = 0,  -- Огненная стрела
    Lightning        = 1,  -- Молния
    Acidray          = 2,  -- Сгусток кислоты
    Fireball         = 3,  -- Огненный шар
    InvokeLightning  = 4,  -- Небесная молния
    ColumnAcid       = 5,  -- Фонтан кислоты
    Firewall         = 6,  -- Огненная стена
    WallLightning    = 7,  -- Стена молний
    PoisonFog        = 8,  -- Кислотный туман
    ProtFire         = 9,  -- Защита от огня
    ProtElectric     = 10, -- Защита от молний
    ProtAcid         = 11, -- Защита от кислоты
    EagleSight       = 12, -- Орлиное зрение
    Infravision      = 13, -- Ночное зрение
    DetectLife       = 14, -- Зрение мертвеца
    Invisibility     = 15, -- Невидимость
    Silence          = 16, -- Неслышный шаг
    Lichdom          = 17, -- Мертвец
    Fireworks        = 18, -- Фейерверк
    Stench           = 19, -- Зловоние (рабочее, но неиспользуемое заклинание)
    Clairvoyence     = 20, -- Ясновидение
    Possession       = 21, -- Отравление (недоделанное заклинание)
    Shapechange      = 22, -- Изменение формы (ничего не делает)
    Visionfog        = 23, -- Поле зрения
    Healing          = 24, -- Лечение
    Stun             = 25, -- Парализация
    Antimagic        = 26, -- Защита от магии
    Link             = 27, -- Связь (ничего не делает)
    Teleport         = 28, -- Телепорт
    Strengthen       = 29, -- Усиление
    Weaken           = 30, -- Ослабление
    Regeneration     = 31, -- Регенерация
    Feeblemind       = 32, -- Слабоумие
    Speed            = 33, -- Ускорение
    Slow             = 34, -- Замедление
    Comprehend       = 35, -- Понимание (ничего не делает)
    Charm            = 36, -- Приручение (недоделанное заклинание, крашит игру)
    Enlarge          = 37, -- Увеличение
    Shrink           = 38, -- Уменьшение
    Campfire         = 39, -- Костер (как в центре поселка на Гипате)
    RickMagic        = 40, -- Магия Тка-Рика
    CurseMagic       = 41  -- Магия Проклятья
}

-- Умения
PerkType = {
    Sword        = 0,  -- Меч
    Axe          = 1,  -- Топор
    Dagger       = 2,  -- Кинжал
    Spear        = 3,  -- Копье
    Hammer       = 4,  -- Молот
    Bow          = 5,  -- Лук
    Crossbow     = 6,  -- Арбалет
    Fire         = 7,  -- Магия огня
    Lightning    = 8,  -- Магия молний
    Acid         = 9,  -- Магия кислот
    Illusion     = 10, -- Магия чувств
    Divination   = 11, -- Магия взгляда (не используется)
    Enchantments = 12, -- Магия астрала
    Healing      = 13, -- Магия лечения (не используется)
    Domination   = 14, -- Магия контроля (не используется)
    Infra        = 15, -- Ночное зрение
    Health       = 16, -- Здоровье
    Mana         = 17, -- Запас сил
    Vitality     = 18, -- Регенерация
    Spirit       = 19, -- Восстановление
    Quickness    = 20, -- Действия
    Lift         = 21, -- Нагрузка
    Backstab     = 22, -- Удар со спины
    Strength     = 23, -- Сила
    Dexterity    = 24, -- Ловкость
    Intelligence = 25  -- Разум
}

-- Список видов оружия
WeaponType = {
    Sword    = 0,  -- Меч
    Axe      = 1,  -- Топор
    Dagger   = 2,  -- Кинжал
    Spear    = 3,  -- Копье
    Hammer   = 4,  -- Молот
    Bow      = 5,  -- Лук
    Crossbow = 6,  -- Арбалет
    Unknown  = 7,  -- ???
    Hands    = 8,  -- Без оружия
    Magic    = 16  -- Магия ("Использует магию"?)
}

-- Список видов брони
ArmorType = {
    Helm    = 0, -- Шлем
    Plate   = 1, -- Тяжелая броня (тело)
    Leggins = 2, -- Тяжелая броня (ноги)
    Shirt   = 3, -- Легкая броня (тело)
    Pants   = 4, -- Легкая броня (ноги)
    Boots   = 5, -- Обувь
    Gloves  = 6, -- Перчатки
    None    = 7  -- Броня отсустствует
}

-- Навыки
ManualSkillType = {
    Science  = 0, -- Наука (не используется)
    Stealing = 1, -- Ловкость рук
    Tame     = 2  -- Приручение (не используется)
}

AutoSkillType = {
    Melee      = 0, -- Ближний бой
    Archery    = 1, -- Стрельба
    Backstab   = 2, -- Удар со спины (не используется)
    Elemental  = 3, -- Магия стихий
    Sense      = 4, -- Магия чувств
    Astral     = 5, -- Магия астрала
    Stealth    = 6, -- Скрытность (не используется)
    Awareness  = 7  -- Восприятие (не используется)
}

-- Органы чувств
SenseType = {
    Sight     = 0, -- Зрение
    Infra     = 1, -- Множитель к обычному зрению на ночное время
    SenseLife = 2, -- Зрение мертвеца
    Hearing   = 3, -- Слух
    Smell     = 4, -- Обоняние
    Tracking  = 5  -- Выслеживание по следам
}

-- Состояние слоя брони
ArmorLayerState = {
    NotUsed  = 0, -- Не используется (нет этой части тела)
    Crippled = 1, -- Повреждено (запас прочности равен нулю) и не дает защиты
    Dead     = 2, -- Часть тела сломана, но броня еще функционирует (?)
    Active   = 3  -- Используется, часть тела не сломана
}

-- Позы юнита
UnitPoseType = {
    Lay   = 0, -- Лежит
    Crawl = 1, -- Присяд
    Stand = 2, -- Стоит/ходит
    Run   = 3, -- Бежит
    Rest  = 4  -- Отдыхает (сидит на земле)
}